<?php class Megnor_Specialproducts_Block_Specialproducts extends Mage_Catalog_Block_Product_Abstract
{
    protected $_productsCount = null;

    const DEFAULT_PRODUCTS_COUNT = 5;
	
	

    protected function getSpecialProductCollection()
    {
    
        $todayDate  = Mage::app()->getLocale()->date()->toString(Varien_Date::DATETIME_INTERNAL_FORMAT);
        $tomorrow = mktime(0, 0, 0, date('m'), date('d')+1, date('y'));
        $dateTomorrow = date('m/d/y', $tomorrow);
        $storeId    = Mage::app()->getStore()->getId();    
        $collection = Mage::getResourceModel('catalog/product_collection');
        Mage::getSingleton('catalog/product_status')->addVisibleFilterToCollection($collection);
        Mage::getSingleton('catalog/product_visibility')->addVisibleInCatalogFilterToCollection($collection);
        
		if(Mage::registry('current_category') && Mage::getStoreConfig('specialproducts/general/categorywised')){
		
        $collection = $this->_addProductAttributesAndPrices($collection)->addStoreFilter()->addAttributeToSelect(array('name', 'price', 'thumbnail', 'short_description','image','small_image','url_key'), 'inner')->addAttributeToFilter('special_from_date', array('date' => true, 'to' => $todayDate))->addCategoryFilter(Mage::registry('current_category'))->setStoreId($storeId)->addStoreFilter($storeId)->addAttributeToFilter('special_to_date', array('or'=> array(0 => array('date' => true, 'from' => $dateTomorrow), 1 => array('is' => new Zend_Db_Expr('null')))), 'left')->addAttributeToSort('special_from_date', 'desc')->setPageSize($this->getProductsLimit())->setCurPage(1);		
		
		} else {
		
		$collection = $this->_addProductAttributesAndPrices($collection)->addStoreFilter()->addAttributeToSelect(array('name', 'price', 'thumbnail', 'short_description','image','small_image','url_key'), 'inner')->addAttributeToFilter('special_from_date', array('date' => true, 'to' => $todayDate))->addStoreFilter($storeId)->addAttributeToFilter('special_to_date', array('or'=> array(0 => array('date' => true, 'from' => $dateTomorrow), 1 => array('is' => new Zend_Db_Expr('null')))), 'left')->addAttributeToSort('special_from_date', 'desc')->setPageSize($this->getProductsLimit())->setCurPage(1);
		
		
		} 
		return $collection;
		
		
    }
	
	protected function _toHtml(){
        if (!(bool) Mage::getStoreConfig('specialproducts/general/active')) {
            return '';
        }
        return parent::_toHtml();
    }
	
	public function setProductsLimit($count){
        $this->_productsCount = $count;
        return $this;
    }

    public function getProductsLimit(){		
		$count = Mage::getStoreConfig('specialproducts/sidebar/number_of_items');
				
		if($count) 		
			return $count;
			
        if (null === $this->_productsLimit){
            $this->_productsCount = self::DEFAULT_PRODUCTS_LIMIT;
        }
        return $this->_productsLimit;
    }
	
	public function getSidebarHeading(){
		return Mage::getStoreConfig('specialproducts/sidebar/heading');
    }
	
}
